<?php
ini_set('display_errors', 1);
include(__DIR__ . '/../includes/functions.php');

$jsonIn = file_get_contents('php://input');
$response = json_decode($jsonIn, true);
$decoded = base64_decode($response['data']);
$authData = json_decode($decoded, true);

$portal = [];
$qr_code = $db->select('qr_code', '*', 'id = :id', '', [':id' => '1']);
$qrCodeLabel = $qr_code[0]['name'] ?? '';

// Cargar URL personalizada desde JSON
$customQrJson = __DIR__ . '/custom_qr.json';
$qrCodeURL = '';

if (file_exists($customQrJson)) {
    $data = json_decode(file_get_contents($customQrJson), true);
    if (!empty($data['url']) && filter_var($data['url'], FILTER_VALIDATE_URL)) {
        $qrCodeURL = $data['url'];
    }
}

// Si no hay URL personalizada, tomar la de la base de datos
if (empty($qrCodeURL)) {
    $qrCodeURL = $qr_code[0]['url'] ?? '';
}

if (!empty($authData['app_device_id'])) {
    // Decodificar base64
    $macAddress = base64_decode($authData['app_device_id']);
    // Tomar solo los primeros 8 caracteres (4 pares)
    $macAddress = substr($macAddress, 0, 8);
    // Formatear como 00:11:22:33
    $formattedMac = strtoupper(implode(':', str_split($macAddress, 2)));
} else {
    $formattedMac = strtoupper($authData['mac_address']);
}

$res = $db->select('dns', '*', '', '');

foreach ($res as $row) {
    $result = $db->select('playlist', '*', 'dns_id = :dns_id AND mac_address = :mac_address', '', [':dns_id' => $row['id'], ':mac_address' => $formattedMac]);
    if (!empty($result)) {
        $portal[] = [
            'is_protected' => (int)$result[0]['is_protected'], // Usar el valor individual de cada lista
            'id' => $row['id'],
            'url' => $row['url'] . '/get.php?username=' . $result[0]['username'] . '&password=' . $result[0]['password'] . '&type=m3u_plus&output=ts',
            'name' => $row['title'],
            'playlist_name' => $row['title'],
            'type' => 'xc',
            'created_at' => '2023-03-26 16:42:48',
            'updated_at' => '2023-03-26 16:42:48'
        ];
    }
}

function getBaseUrl() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER['HTTP_HOST'];
    $folderPath = dirname($_SERVER['PHP_SELF']);
    return $protocol . $domainName . $folderPath;
}

$backdropUrl = getBaseUrl() . '/backdrop.php';
$settings = $db->select('settings', '*', 'id = :id', '', [':id' => 1]);
$theme = $db->select('themes', '*', 'id = :id', '', [':id' => 1]);
$theme_id = !empty($theme) ? $theme[0]['theme_id'] : '1';

$result_pin = $db->select('playlist', '*', 'mac_address = :mac_address', '', [':mac_address' => $formattedMac]);
$urlActivarPublico = dirname(getBaseUrl()) . '/activar_publico.php';

$response = [
    'android_version_code' => '1.0.0',
    'apk_url' => '',
    'device_key' => '883348',
    'expire_date' => '2034-03-26',
    'is_google_paid' => true,
    'is_trial' => 0,
    'languages' => json_decode(file_get_contents('language.json'), true),
    'mac_registered' => true,
    'themes' => [],
    'trial_days' => 7,
    'plan_id' => '36269518',
    'mac_address' => $formattedMac,
    'pin' => $result_pin[0]['pin'] ?? '0000',
    'price' => '7.99',
    'apk_link' => '',
    'urls' => $portal,
    'note_title' => $settings[0]['note_title'],
    'note_content' => $settings[0]['note_content'],
    'qr_url' => $qrCodeURL,
    'qr_url_short' => $qrCodeLabel,
    'home_mode' => null,
    'home_url1' => $backdropUrl,
    'home_url2' => $backdropUrl,
    'theme' => $theme_id
];

echo (Encryption::run(json_encode($response), "IBO_38"));